/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.commands;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.skinsrestorer.api.interfaces.ISRCommandSender;
import net.skinsrestorer.api.interfaces.ISRProxyPlayer;
import net.skinsrestorer.shadow.aikar.commands.CommandHelp;
import net.skinsrestorer.shared.interfaces.ISRProxyPlugin;
import net.skinsrestorer.shared.storage.CooldownStorage;
import net.skinsrestorer.shared.storage.Locale;

public interface IProxyGUICommand {
    default public void onHelp(ISRCommandSender sender, CommandHelp help) {
        sender.sendMessage("SkinsRestorer Help");
        help.showHelp();
    }

    default public void onDefault(ISRProxyPlayer player) {
        if (!player.hasPermission("skinsrestorer.bypasscooldown") && CooldownStorage.hasCooldown(player.getName())) {
            player.sendMessage(Locale.SKIN_COOLDOWN.replace("%s", String.valueOf(CooldownStorage.getCooldown(player.getName()))));
            return;
        }
        player.sendMessage(Locale.SKINSMENU_OPEN);
        this.sendGuiOpenRequest(player);
    }

    default public void sendGuiOpenRequest(ISRProxyPlayer player) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(b);
        try {
            out.writeUTF("OPENGUI");
            out.writeUTF(player.getName());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        player.sendDataToServer("sr:messagechannel", b.toByteArray());
    }

    public ISRProxyPlugin getPlugin();
}

